﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.POS
{
    public partial class SendToKitchen : System.Web.UI.Page
    {
        private static List<ProductMeasurement> AllSizes;
        private static List<Products> AllProducts;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                AllSizes = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
                if (AllSizes != null && AllSizes.Count > 0)
                {
                    AllSizes = AllSizes.Where(a => a.IsActive).ToList<ProductMeasurement>();
                }
                AllProducts = ProductsBL.GetList(Guid.Empty, string.Empty);
                if (AllProducts != null && AllProducts.Count > 0)
                {
                    AllProducts = AllProducts.Where(a => a.IsActive).ToList<Products>();
                }
                LoadReceipt();
            }
            
        }

        protected void rptProductsReceipt_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            Label lblControl = e.Item.FindControl("lblSizeName") as Label;
            if (lblControl != null && AllSizes != null)
            {
                Guid ProductID = Guid.Parse(lblControl.Attributes["data-ProductID"].ToString());
                Products CurrProduct = AllProducts.Where(a=>a.UniqueID == ProductID).SingleOrDefault();
                lblControl.Text = AllSizes.Where(a => a.UniqueID == CurrProduct.ProductMeasurementID).Select(a => a.MeasurementName).SingleOrDefault();
            }
        }

        private void LoadReceipt()
        {
            lblReceiptCashier.Text = WebSession.CurrentAdminUser.FirstName;
            lblReceiptTableNumber.Text = WebSession.CurrentPOSOrders.TableNumber;
            rptProductsReceipt.DataSource = WebSession.CurrentPOSOrders.OrdersDetailsList;
            rptProductsReceipt.DataBind();
        }
    }
}
